unit MAIN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ExtCtrls, GraphXYv51, StdCtrls, Buttons, Math, StrUtils,
  ComCtrls,
  MyMath1V1;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    ColorDialog1: TColorDialog;
    BttNextGraph: TButton;
    ButtonSaveToFile: TButton;
    SaveDialog1: TSaveDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Panel4: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    CBoxFuncId: TComboBox;
    CBoxPeriodNum: TComboBox;
    CBoxFuncArgum: TComboBox;
    Panel2: TPanel;
    Bevel4: TBevel;
    SpeedButtonBkGrColor5: TSpeedButton;
    Label14: TLabel;
    SpeedButtonGridColor: TSpeedButton;
    Label15: TLabel;
    SpeedButtonAxesColor: TSpeedButton;
    Label16: TLabel;
    EdXBeg: TEdit;
    EdXEnd: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    CbBoxFuncStyle: TComboBox;
    ButtNewGraph: TButton;
    Label7: TLabel;
    SpeedButtonFuncColor: TSpeedButton;
    Label1: TLabel;
    STextFuncColor: TStaticText;
    Label17: TLabel;
    Panel3: TPanel;
    Label9: TLabel;
    Bevel3: TBevel;
    Label10: TLabel;
    Label11: TLabel;
    ComboBoxPicX: TComboBox;
    ComboBoxPicY: TComboBox;
    procedure SpeedButtonBkGrColor5Click(Sender: TObject);
    procedure ComboBoxPicXChange(Sender: TObject);
    procedure ComboBoxPicYChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedButtonGridColorClick(Sender: TObject);
    procedure SpeedButtonAxesColorClick(Sender: TObject);
    procedure BttNextGraphClick(Sender: TObject);
    procedure ButtonSaveToFileClick(Sender: TObject);
    procedure ButtNewGraphClick(Sender: TObject);
    procedure SpeedButtonFuncColorClick(Sender: TObject);
    procedure CBoxFuncArgumClick(Sender: TObject);
    procedure CBoxPeriodNumClick(Sender: TObject);
    procedure EdXBegChange(Sender: TObject);
    procedure EdXEndChange(Sender: TObject);
  private
    { Private declarations }
    procedure MakeGraph();
  public
    { Public declarations }
  end;

  //   
  procedure ReShowRange (RqEditXB, RqEditXE : TEdit; RqXStyle : TCombobox);

var
  Form1      : TForm1;   //    

implementation

{$R *.dfm}

// =========================================================
//     
// =========================================================
const MaxInd = 200;      //    

var
    GraphXY1   : TGraphXY; //    
    GraphColor : TColor;   //   

var
    XBeg       : double;   //     
    XEnd       : double;   //      

//     
var Graph  : TGraphArr;

//=====================================================
//      GraphXY   
//=====================================================
//    GraphXY1   Panel1
procedure TForm1.FormCreate(Sender: TObject);
begin
   SetLength(Graph, MaxInd+1);
   //   
   if GraphXY1 = nil
   then begin
      //       
      GraphXY1:=TGraphXY.Create(Panel1);
      // 
      GraphColor := RGB(64,64,164);
      STextFuncColor.Color := GraphColor;
      GraphXY1.PicAxesY := ComboBoxPicY.Text;
   end;
   //   
   CBoxPeriodNum.ItemIndex := 0;   //  
   CBoxFuncArgum.ItemIndex := 0;   //    
   CbBoxFuncStyle.ItemIndex := 0;  //  
   EdXBeg.Text := '-90';           //    XBeg
   EdXEnd.Text := '90';            //    XEnd
end;
//    GraphXY1
procedure TForm1.FormDestroy(Sender: TObject);
begin
   if GraphXY1 <> nil
   then begin
      GraphXY1.Free;
   end;
end;

//=====================================================
//      GraphXY1  
//=====================================================
//=====================================================
//      
//=====================================================
//      
procedure TForm1.ButtonSaveToFileClick(Sender: TObject);
begin
  SaveDialog1.Filter := 'JPEG files (*.jpg)|*.jpg|BMP files (*.bmp)|*.bmp';
  SaveDialog1.FilterIndex := 1;  //      JPEG
  if SaveDialog1.Execute
  then begin
     case SaveDialog1.FilterIndex of
     1 : begin  //   JPEG
           GraphXY1.SaveGraphXY(SaveDialog1.FileName,'J');
         end;
     2 : begin  //   BMP
           GraphXY1.SaveGraphXY(SaveDialog1.FileName,'B');
         end;
     end; {of case}
  end;
end;

//=====================================================
//    
//=====================================================
//      
procedure TForm1.SpeedButtonFuncColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    GraphColor := ColorDialog1.Color;
    STextFuncColor.Color := GraphColor;
  end;
end;
//     
procedure TForm1.SpeedButtonBkGrColor5Click(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    GraphXY1.BackGroundColor := ColorDialog1.Color;
  end;
end;
//     
procedure TForm1.SpeedButtonGridColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    GraphXY1.GridColor := ColorDialog1.Color;
  end;
end;
//     
procedure TForm1.SpeedButtonAxesColorClick(Sender: TObject);
begin
  if ColorDialog1.Execute
  then begin
    GraphXY1.AxesColor := ColorDialog1.Color;
  end;
end;

//=====================================================
//       
//=====================================================
//      X
procedure TForm1.ComboBoxPicXChange(Sender: TObject);
begin
 GraphXY1.PicAxesX := ComboBoxPicX.Text;
end;
//      Y
procedure TForm1.ComboBoxPicYChange(Sender: TObject);
begin
 GraphXY1.PicAxesY := ComboBoxPicY.Text;
end;

//=====================================================
//    
//=====================================================
//    Edit.Text  
function EditTextToFloat (RqEdit : TEdit; var Value : double) : boolean;
var BufReal  : double;
begin
  Result  := False;     //   
  BufReal := Value;
  try
    Value := StrToFloat(RqEdit.Text);
    RqEdit.Color := clWindow;
    Result := True;    //   
  except
    Value := BufReal;
    RqEdit.Color := clCream;
    ShowMessage('    ');
  end;
end;

//   
procedure ReShowRange (RqEditXB, RqEditXE : TEdit; RqXStyle : TCombobox);
begin
     //   
     case RqXStyle.ItemIndex of
     0 : RqEditXB.Text := FloatToStr(XBeg / Pi * 180);
     1 : RqEditXB.Text := FloatToStr(XBeg);
     end;
     //   
     case RqXStyle.ItemIndex of
     0 : RqEditXE.Text := FloatToStr(XEnd / Pi * 180);
     1 : RqEditXE.Text := FloatToStr(XEnd);
     end;
end;

//   
procedure MkRange (RqEditXB, RqEditXE : TEdit; RqXStyle, RqXLen : TCombobox);
begin
   //   
   XBeg := - (RqXLen.ItemIndex + 1) * Pi;
   //   
   XEnd :=   (RqXLen.ItemIndex + 1) * Pi;
   // 
   ReShowRange(RqEditXB, RqEditXE, RqXStyle);
end;

//    
procedure TForm1.CBoxFuncArgumClick(Sender: TObject);
begin
   MkRange(EdXBeg, EdXEnd, CBoxFuncArgum, CBoxPeriodNum);
end;

//    
procedure TForm1.CBoxPeriodNumClick(Sender: TObject);
begin
   MkRange(EdXBeg, EdXEnd, CBoxFuncArgum, CBoxPeriodNum);
end;

//   
procedure TForm1.EdXBegChange(Sender: TObject);
var Buf : double;
begin
 if EditTextToFloat(EdXBeg, Buf)
 then begin
    case CBoxFuncArgum.ItemIndex of
     0 : XBeg := Pi * Buf / 180;
     1 : XBeg := Buf;
     end;
 end else Beep;
end;

//   
procedure TForm1.EdXEndChange(Sender: TObject);
var Buf : double;
begin
  if EditTextToFloat(EdXEnd, Buf)
  then begin
    case CBoxFuncArgum.ItemIndex of
     0 : XEnd := Pi * Buf / 180;
     1 : XEnd := Buf;
     end;
 end else Beep;
end;

//=====================================================
//       Graph
//=====================================================
procedure TForm1.MakeGraph();
var   Ind   : integer;  //  
      XStep : double;   //   
      XR    : double;   //    
      XN    : double;   //    
begin
   XStep := (XEnd - XBeg) / MaxInd;
   //      
   for Ind := 0 to MaxInd do
   begin
      //   
      XR := XBeg + XStep * Ind;
      case CBoxFuncArgum.ItemIndex of
      //     
      0 : Graph[Ind].X := XR / Pi * 180 ;
      //     
      1 : Graph[Ind].X := XR;
      end;
      //    .
      case CBoxFuncId.ItemIndex of
      0 : begin
            //     
            if Abs(XR) <= 2* Pi
            then XN := XR
            else XN := 2 * Pi * Frac(XR /(2* Pi));
            //    
            case CbBoxFuncStyle.ItemIndex of
               0: Graph[Ind].Y := Tailor(SinCoeff, XN);
               1: Graph[Ind].Y := Tailor(SinCoeff, XN) - Sin(XR);
            end;
          end;
      1 : begin
            //     
            if Abs(XR) <= 2* Pi
            then XN := XR
            else XN := 2 * Pi * Frac(XR /(2* Pi));
            //    
            case CbBoxFuncStyle.ItemIndex of
               0: Graph[Ind].Y := Tailor(CosCoeff, XN);
               1: Graph[Ind].Y := Tailor(CosCoeff, XN)  - Cos(XR);
            end;
          end;
      2 : Graph[Ind].Y := Tailor(SiCoeff, XR);
      3 : Graph[Ind].Y := Tailor(SinCCoeff, XR);
      4 : begin
            case CbBoxFuncStyle.ItemIndex of
               0: Graph[Ind].Y := Tailor(ShCoeff, XR);
               1: Graph[Ind].Y := Tailor(ShCoeff, XR) - (Exp(XR) - Exp(-XR))/2;
            end;
          end;
      5 : begin
            case CbBoxFuncStyle.ItemIndex of
               0: Graph[Ind].Y := Tailor(ChCoeff, XR);
               1: Graph[Ind].Y := Tailor(ChCoeff, XR) - (Exp(XR) + Exp(-XR))/2;
            end;
          end;
      else Graph[Ind].Y := 0;
      end;
   end;
end;

//=====================================================
//    
//=====================================================
//     
procedure TForm1.ButtNewGraphClick(Sender: TObject);
begin
   //       Graph
   MakeGraph();
   //     
   GraphXY1.FullEraseAreaXY;
   GraphXY1.GraphTitul := CBoxFuncId.Text;
   GraphXY1.ShowGraphXY(Graph, GraphColor);
end;

//      
procedure TForm1.BttNextGraphClick(Sender: TObject);
begin
   //       Graph
   MakeGraph();
   GraphXY1.GraphTitul := CBoxFuncId.Text;
   //     
   GraphXY1.ShowGraphXY(Graph, GraphColor);
end;






end.
